define([
    'underscore',
    'marionette',
    'text!modules/appointments/booked/pagination/booked-appointments-top-pagination.html',
    'modules/appointments/appointments-module',
    'backbone',
    'backgrid',
    'backgrid-paginator',
],
function (_, Marionette, template, module, Backbone, Backgrid, BackgridPaginator) {
    'use strict';

    return Marionette.View.extend({

        template: _.template(template),
        ui: {
            paginator: '#top-paginator',
        },
        onShow: function() {
            // var defaultWindowSize = 10;

            var paginatorComponent = new Backgrid.Extension.Paginator({
                collection: this.collection,
                showPaginationControls: false,
            });
            paginatorComponent.windowSize = this.collection.fullCollection.length;
            this.ui.paginator.append(paginatorComponent.render().$el);
        },
        onRender: function() {
            if (this.collection !== undefined && this.collection.fullCollection !== undefined &&
                this.collection.fullCollection.length > 0) {
                this.onShow();
            }
        },

    });
}
);
